% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxDrop1}
\alias{umxDrop1}
\title{umxDrop1: Unfinished function to mimic drop1 in OpenMx}
\usage{
umxDrop1(model, regex = NULL, maxP = 1)
}
\arguments{
\item{model}{An \code{\link{mxModel}} to drop parameters from}

\item{regex}{A string to select parameters to drop. leave empty to try all.
This is regular expression enabled. i.e., "^a_" will drop parameters beginning with "a_"}

\item{maxP}{The threshold for returning values (defaults to p==1 - all values)}
}
\value{
a table of model comparisons
}
\description{
Drops each free parameter (selected via regex), returning an \code{\link{mxCompare}}
table comparing the effects. A great way to quickly determine which of several 
parameters can be dropped without excessive cost
}
\examples{
\dontrun{
umxDrop1(fit3) # try dropping each free parameters (default)  
# drop "a_r1c1" and "a_r1c2" and see which matters more.
umxDrop1(model, regex="a_r1c1|a_r1c2")
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Modify or Compare Models: \code{\link{umxAdd1}},
  \code{\link{umxEquate}}, \code{\link{umxFixAll}},
  \code{\link{umxMI}}, \code{\link{umxModify}},
  \code{\link{umxSetParameters}},
  \code{\link{umxUnexplainedCausalNexus}},
  \code{\link{umx}}
}
