% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{install.OpenMx}
\alias{install.OpenMx}
\alias{umx_update_OpenMx}
\title{Install OpenMx, with choice of builds}
\usage{
install.OpenMx(loc = c("NPSOL", "travis", "CRAN", "open travis build page",
  "UVa"), url = NULL, lib, repos = getOption("repos"))
}
\arguments{
\item{loc}{Which install to get: "UVa" (the default), "travis" (latest build),
or open the travis list of builds on the web to view/pick a url.}

\item{url}{A custom URL if you have/need one (probably not).}

\item{lib}{Where to install the package.}

\item{repos}{Which repository to use (ignored currently).}
}
\value{
-
}
\description{
You can install OpenMx, including the latest parallel/NPSOL enabled build of OpenMx. Options are:

1. "NPSOL": Install from our repository (default: This is where we maintain binaries supporting parallel processing and NPSOL).

2. "travis": Install the latest travis built (currently MacOS only).

3. "CRAN": Install from CRAN.

4. "open travis build page": Open the list of travis builds in a browser window.
}
\examples{
\dontrun{
install.OpenMx() # gets the NPSOL version
install.OpenMx("NPSOL") # gets the NPSOL version explicitly
install.OpenMx("CRAN") # Get the latest CRAN version
install.OpenMx("open travis build page") # Open web page of travis builds
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
\code{\link{umxVersion}}

Other Miscellaneous Utility Functions: \code{\link{qm}},
  \code{\link{umxBrownie}}, \code{\link{umxFactor}},
  \code{\link{umxVersion}}, \code{\link{umx_array_shift}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_find_object}}, \code{\link{umx_make}},
  \code{\link{umx_msg}}, \code{\link{umx_open_CRAN_page}},
  \code{\link{umx_pad}}, \code{\link{umx_pb_note}},
  \code{\link{umx_print}}, \code{\link{umx_scale}},
  \code{\link{umx}}
}
