% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{tmx_show}
\alias{tmx_show}
\title{Show matrices of RAM models in a easy-to-learn-from format.}
\usage{
tmx_show(model, what = c("values", "free", "labels", "nonzero_or_free"),
  show = c("free", "fixed", "all"), matrices = c("S", "A", "M"),
  digits = 2, report = c("markdown", "inline", "html", "report"),
  na.print = "", zero.print = ".")
}
\arguments{
\item{model}{an \code{\link{mxModel}} from which to show parameters.}

\item{what}{legal options are "values" (default), "free", or "labels").}

\item{show}{filter on what to show c("all", "free", "fixed").}

\item{matrices}{to show  (default is c("S", "A")). "Thresholds" in beta.}

\item{digits}{precision to report. Default = round to 2 decimal places.}

\item{report}{How to report the results. "html" = open in browser.}

\item{na.print}{How to display NAs (default = "")}

\item{zero.print}{How to display 0 values (default = ".")}
}
\value{
-
}
\description{
A great way to learn about models is to look at the matrix contents. `tmx_show` is designed to
do this in a way that makes it easy to process for users: The matrix contents are formatted as tables, and can even 
be displayed as tables in a web browser.
}
\details{
The user can select which matrices to view, whether to show values, free, and/or labels, and the precision of rounding.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("g")
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)

tmx_show(m1)
tmx_show(m1, digits = 3)
tmx_show(m1, matrices = "S")
tmx_show(m1, what = "free")
tmx_show(m1, what = "labels")
tmx_show(m1, what = "free", matrices = "A")
}
\references{
- \url{https://tbates.github.io}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umxWeightedAIC}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_time}}, \code{\link{umx}},
  \code{\link{xmu_get_CI}}
}
\concept{Reporting Functions}
