% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_long2wide}
\alias{umx_long2wide}
\title{Take a long twin-data file and make it wide (one family per row)}
\usage{
umx_long2wide(data, famID = NA, twinID = NA, zygosity = NA,
  vars2keep = NA, passalong = NA)
}
\arguments{
\item{data}{The original (long-format) data file}

\item{famID}{The unique identifier for members of a family}

\item{twinID}{The twinID. Typically 1, 2, 50 51, etc...}

\item{zygosity}{Typically MZFF, DZFF MZMM, DZMM DZOS}

\item{vars2keep}{= The variables you wish to analyse (these will be renamed with paste0("_T", twinID)}

\item{passalong}{= Variables you wish to pass-through (keep, even though not twin vars)}
}
\value{
- dataframe in wide format
}
\description{
umx_long2wide merges on famID, for an unlimited number of twinIDs.
Note: this assumes if zygosity or any passalong variables are NA in the first
family member, they are NA everywhere. i.e., it does not hunt for values that
are present elsewhere to try and self-heal missing data.
}
\examples{
# ================================================================
# = First we have to make a long format file to base the demo on =
# ================================================================
tmp = twinData[, -2]
tmp$twinID1 = 1
tmp$twinID2 = 2
long = umx_wide2long(data = tmp, sep = "")
#
# OK. Now to demo long2wide...
# Keeping all columns
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity")
names(wide) # might want to rename vars like "part_T1" to "part" and delete T2 copy 
# Just keep bmi and wt
k = c("bmi", "wt")
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", 
    zygosity= "zygosity", vars2keep = k)
names(wide)
# "fam" "twinID" "zygosity" "bmi_T1" "wt_T1" "bmi_T2" "wt_T2"
# Keep bmi and wt, and pass through 'cohort'
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity", 
	vars2keep = k, passalong = "cohort")
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{merge}}

Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx_wide2long}}, \code{\link{umx}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxReduceACE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_wide2long}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
