% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotACE}
\alias{umxPlotACE}
\alias{plot.MxModel.ACE}
\title{umxPlotACE}
\usage{
umxPlotACE(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, showMeans = "deprecated", showStd = "deprecated", ...)
}
\arguments{
\item{x}{\code{\link{mxModel}} to plot (created by umxACE in order to inherit the MxModel.ACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{showMeans}{DEPRECATED: just use 'means = ' for simplicity of typing.}

\item{showStd}{DEPRECATED: just use 'std = '}

\item{...}{Additional (optional) parameters}
}
\value{
- optionally return the dot code
}
\description{
Make a graphical display of an ACE model
}
\examples{
require(umx)
data(twinData)
selDVs = "bmi"
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData, sep = "")
plot(m1, std = FALSE) # don't standardize
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACEv}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
