% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotACEcov}
\alias{plot.MxModel.ACEcov}
\alias{umxPlotACEcov}
\title{umxPlotACEcov}
\usage{
umxPlotACEcov(x = NA, dotFilename = "name", digits = 2,
  showMeans = FALSE, std = TRUE, ...)
}
\arguments{
\item{x}{\code{\link{mxModel}} to plot (created by umxACE in order to inherit the MxModel.ACE class)}

\item{dotFilename}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{showMeans}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{...}{Additional (optional) parameters}
}
\value{
- optionally return the dot code
}
\description{
Make a graphical display of an ACE model
}
\examples{
# Height, weight, and BMI data from Australian twins. 
# The total sample has been subdivided into a young cohort, aged 18-30 years,
# and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows: 
# 1 == MZ females 2 == MZ males 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
# tip: ?twinData to learn more about this data set
require(umx)
data(twinData)
tmpTwin <- twinData
# add age 1 and age 2 columns
tmpTwin$age1 = tmpTwin$age2 = tmpTwin$age
# Pick the variables. We will use base names (i.e., "bmi") and set suffix.
selDVs  = c("bmi")
selCovs = c("age")
selVars = umx_paste_names(c(selDVs, selCovs), textConstant = "", suffixes= 1:2)
# just top 200 so example runs in a couple of secs
mzData = subset(tmpTwin, zyg == 1, selVars)[1:200, ]
dzData = subset(tmpTwin, zyg == 3, selVars)[1:200, ]
# TODO update for new dataset variable zygosity
# mzData = subset(tmpTwin, zygosity == "MZFF", selVars)[1:200, ]
# dzData = subset(tmpTwin, zygosity == "DZFF", selVars)[1:200, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs, dzData = dzData, mzData = mzData, 
	 suffix = "", autoRun = TRUE)
\dontrun{
plot(m1)
umxPlotACEcov(m1, dotFilename = "override_model_name")
plot(m1, std = FALSE) # don't standardize
}
}
\references{
- \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

