% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxEquate}
\alias{umxEquate}
\title{umxEquate}
\usage{
umxEquate(model, master, slave, free = c(TRUE, FALSE, NA), verbose = TRUE,
  name = NULL)
}
\arguments{
\item{model}{An \code{\link{mxModel}} within which to equate parameters}

\item{master}{A list of "master" labels to which slave labels will be equated}

\item{slave}{A list of slave labels which will be updated to match master labels, thus equating the parameters}

\item{free}{Should parameter(s) initally be free? (default = TRUE)}

\item{verbose}{Whether to give verbose feedback (default = TRUE)}

\item{name}{name for the returned model (optional: Leave empty to leave name unchanged)}
}
\value{
- \code{\link{mxModel}}
}
\description{
Equate parameters by setting one or more labels (the slave set) equal
to the labels in a master set.
Setting two or more parameters to have the same
\code{\link{umxLabel}} constrains them to take the same value.
}
\details{
note: In addition to using this method to equating parameters, you can
also equate one parameter to another by setting its label to the
"square bracket" address of the master, e.g. "a[r,c]".

Tip: To find labels of free parameters use \code{\link{umxGetParameters}} with free = T
Tip: To find labels by name, use the regex parameter of \code{\link{umxGetParameters}}
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m2 = umxEquate(m1, master = "G_to_x1", slave = "G_to_x2", name = "Equate x1 and x2 loadings")
m2 = mxRun(m2) # have to run the model again...
umxCompare(m1, m2) # not good :-)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Modify or Compare Models: \code{\link{parameters}},
  \code{\link{umxGetParameters}}; \code{\link{umxAdd1}};
  \code{\link{umxDrop1}}; \code{\link{umxFixAll}};
  \code{\link{umxMI}}; \code{\link{umxSetParameters}};
  \code{\link{umxUnexplainedCausalNexus}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

