% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_templates.R
\name{html_imetropolis}
\alias{html_imetropolis}
\title{"Illinois" (UIUC) Metropolis themed HTML Template for RMarkdown}
\usage{
html_imetropolis(self_contained = FALSE, seal = TRUE,
  chakra = "https://remarkjs.com/downloads/remark-latest.min.js",
  nature = list(), ...)
}
\arguments{
\item{self_contained}{Whether to produce a self-contained HTML file.}

\item{seal}{Whether to generate a title slide automatically using the YAML
metadata of the R Markdown document (if \code{FALSE}, you should write the
title slide by yourself).}

\item{chakra}{A path to the remark.js library (can be either local or
remote).}

\item{nature}{(Nature transformation) A list of configurations to be passed
to \code{remark.create()}, e.g. \code{list(ratio = '16:9', navigation =
list(click = TRUE))}; see
\url{https://github.com/gnab/remark/wiki/Configuration}. Besides the
options provided by remark.js, you can also set \code{autoplay} to a number
(the number of milliseconds) so the slides will be played every
\code{autoplay} milliseconds. You can also set \code{countdown} to a number
(the number of milliseconds) to include a countdown timer on each slide. If
using \code{autoplay}, you can optionally set \code{countdown} to
\code{TRUE} to include a countdown equal to \code{autoplay}. To alter the
set of classes applied to the title slide, you can optionally set
\code{titleSlideClass} to a vector of classes; the default is
\code{c("center", "middle", "inverse")}.}

\item{...}{For \code{tsukuyomi()}, arguments passed to \code{moon_reader()};
for \code{moon_reader()}, arguments passed to
\code{rmarkdown::\link{html_document}()}.}
}
\value{
A modified \code{\link[xaringan:moon_reader]{xaringan::moon_reader()}} based on the "Illinois" (UIUC)
Metropolis themed HTML template.
}
\description{
Generates from an RMarkdown file an HTML presentation with "Illinois" (UIUC)
colors and identity standards based on the Metropolis theme.
}
\examples{

\dontrun{
# Generate slide deck from beamer template
rmarkdown::draft("slide_deck.Rmd", template = "html_imetropolis", package = "uiucthemes")

# Compile the document
rmarkdown::render("slide_deck/slide_deck.Rmd")
}
}
\author{
James Joseph Balamuta (Light Modifications of Metropolis and R function wrapper)
See AUTHORS for more specific details behind each of the contributions.
}
