% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecTxt.R
\name{vecTxt}
\alias{vecTxt}
\alias{vecTxtQ}
\title{Easily parse a vector into a character value}
\usage{
vecTxt(vector, delimiter = ", ", useQuote = "",
  firstDelimiter = NULL, lastDelimiter = " & ", firstElements = 0,
  lastElements = 1, lastHasPrecedence = TRUE)

vecTxtQ(vector, useQuote = "'", ...)
}
\arguments{
\item{vector}{The vector to process.}

\item{delimiter, firstDelimiter, lastDelimiter}{The delimiters
to use for respectively the middle, first
`firstElements`, and last `lastElements` elements.}

\item{useQuote}{This character string is pre- and appended to all elements;
so use this to quote all elements (`useQuote="'"`), doublequote all
elements (`useQuote='"'`), or anything else (e.g. `useQuote='|'`).
The only difference between `vecTxt` and `vecTxtQ` is that the
latter by default quotes the elements.}

\item{firstElements, lastElements}{The number of elements for which to use
the first respective last delimiters}

\item{lastHasPrecedence}{If the vector is very short, it's possible that the
sum of firstElements and lastElements is larger than the vector length. In
that case, downwardly adjust the number of elements to separate with the
first delimiter (`TRUE`) or the number of elements to separate with the
last delimiter (`FALSE`)?}

\item{...}{Any addition arguments to `vecTxtQ` are passed on to
`vecTxt`.}
}
\value{
A character vector of length 1.
}
\description{
Easily parse a vector into a character value
}
\examples{
vecTxtQ(names(mtcars));
}
