# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' Files encoding detection
#'
#' @description
#' This function tries to detect character encoding of files.
#'
#' @param x Character vector, containing file names or paths.
#'
#' @return A character vector of length equal to the length of x and contains
#' guessed iconv-compatible encodings names.
#'
#' @export
#'
#' @encoding UTF-8
#'
#' @example man-roxygen/ex_detect_file.R
#'
detect_file_enc <- function(x) {
    .Call(`_uchardet_detect_file_enc`, x)
}

#' @title
#' Raw bytes encoding detection
#'
#' @description
#' This function tries to detect raw bytes encoding.
#'
#' @param x Raw vector.
#'
#' @return A character which contains a guessed iconv-compatible encoding name.
#'
#' @export
#'
#' @encoding UTF-8
#'
#' @example man-roxygen/ex_detect_raw.R
#'
detect_raw_enc <- function(x) {
    .Call(`_uchardet_detect_raw_enc`, x)
}

#' @title
#' String encoding detection
#'
#' @description
#' This function tries to detect character encoding.
#'
#' @param x Character vector.
#'
#' @return A character vector of length equal to the length of x and contains
#' guessed iconv-compatible encodings names.
#'
#' @encoding UTF-8
#'
#' @example man-roxygen/ex_detect_str.R
#'
#' @export
#'
detect_str_enc <- function(x) {
    .Call(`_uchardet_detect_str_enc`, x)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_uchardet_RcppExport_registerCCallable', PACKAGE = 'uchardet')
})
