% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R, R/occu.R, R/pcount.R
\name{gof}
\alias{gof}
\alias{plot,ubmsGOF,ANY-method}
\alias{gof,ubmsFitOccu-method}
\alias{gof,ubmsFitAbun-method}
\title{Check model goodness-of-fit}
\usage{
gof(object, draws = NULL, ...)

\S4method{gof}{ubmsFitOccu}(object, draws = NULL, quiet = FALSE, ...)

\S4method{gof}{ubmsFitAbun}(object, draws = NULL, quiet = FALSE, ...)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{draws}{Number of draws from the posterior to use in the check}

\item{...}{Currently ignored}

\item{quiet}{If \code{TRUE}, suppress progress bar}
}
\value{
An object of class \code{ubmsGOF} containing statistics calculated
from the posterior predictive distribution.
}
\description{
Goodness-of-fit tests for \code{ubmsFit} models using posterior predictive
checks
}
\section{Functions}{
\itemize{
\item \code{gof(ubmsFitOccu)}: Applies the MacKenzie-Bailey chi-square goodness of fit test for
ocupancy models (MacKenzie and Bailey 2004).

\item \code{gof(ubmsFitAbun)}: A goodness-of-fit test for N-mixture type models based on Pearson's chi-square.

}}
\references{
MacKenzie, D. I., & Bailey, L. L. (2004). Assessing the
 fit of site-occupancy models. Journal of Agricultural, Biological,
 and Environmental Statistics, 9(3), 300-318.
}
