% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_report_init}
\alias{system_report_init}
\title{Initialize a New Officer Report}
\usage{
system_report_init(
  cfg,
  template = NULL,
  rptname = "default",
  rpttype = NULL,
  meta = NULL
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{template}{path to template file (\code{NULL} will load the default ubiquity template)}

\item{rptname}{report name}

\item{rpttype}{type of report to create, can be either \code{NULL}, \code{"PowerPoint"} or \code{"Word"}}

\item{meta}{list containing metadata identifying relevant indices for slide layouts}
}
\value{
ubiquity system object with estimation report initialized
}
\description{
Creates a new officer report based either on the ubiquity
template or one specified by the user. Once created, content can then be
added.
}
\details{
Either the rpttype can be specified or the template. If a report type is
  specified the internal ubiquity template for that type will be used. If
  the user specifies a template, the type will be determined from the file
  extension. If both values are NULL the report type will default to 
  "PowerPoint" internally.
}
\seealso{
Reporting vignette (\code{vignette("Reporting", package = "ubiquity")})
}
