% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_classify.R
\name{get_traindata}
\alias{get_traindata}
\title{Extracts training data from a raster stack using vector data as a mask.}
\usage{
get_traindata(rasterStack = NULL, trainPlots = NULL)
}
\arguments{
\item{rasterStack}{an object of rasterstack*. containing image data to make prediction on}

\item{trainPlots}{an object of SpatialPolygonDataFrame*. providing the training areas}
}
\description{
Extracts training data from a raster stack and returns a dataframe containing for each pixel all values.
}
\examples{
\dontrun{
##- required packages
require(uavRst)
require(link2GI)

##- project folder
projRootDir<-tempdir()

##- create subfolders please mind that the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = projRootDir,
                        projFolders = c("data/","data/ref/","output/","run/","las/"),
                        global = TRUE,
                        path_prefix = "path_")
##- overide trailing backslash issue
path_run<-ifelse(Sys.info()["sysname"]=="Windows", sub("/$", "",path_run),path_run)
setwd(path_run)
unlink(paste0(path_run,"*"), force = TRUE)

##- get the tutorial data
utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip",
                     paste0(path_run,"tutorial_data.zip"))
unzip(paste0(path_run,"tutorial_data.zip"),exdir =  path_run)

##- get the files
imageTrainStack <- list()
geomTrainStack <- list()
imageTrainFiles <- Sys.glob(paste0(path_run,"rgb*.tif"))
geomTrainFiles <- Sys.glob(paste0(path_run,"rgb*.shp"))

##- create stacks from image and geometry files
imageTrainStack<-lapply(imageTrainFiles, FUN=raster::stack)
geomTrainStack  <- lapply(geomTrainFiles, FUN=raster::shapefile)
names(imageTrainStack[[1]])<-c("red","green","blue")
names(imageTrainStack[[2]])<-c("red","green","blue")

##' finally extraxt the training data to a data frame
trainDF <- get_traindata(rasterStack  = imageTrainStack,
                        trainPlots = geomTrainStack)

##- have a look at the training data
head(trainDF)
}
}
\author{
Chris Reudenbach
}
