% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{summary,summary_sam-method}
\alias{summary,summary_sam-method}
\alias{summary_sam}
\title{Method to summarize \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} objects.}
\usage{
\S4method{summary}{summary_sam}(object, ...)

summary_sam(
  object,
  mask = NULL,
  clusternames = NULL,
  slice = 1,
  window = NULL,
  smooth = TRUE,
  temporal = FALSE
)
}
\arguments{
\item{object}{An object of class \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}}. It accepts also object of S3 class "clipper" returned by the \code{\link{clipper}} function.}

\item{...}{other parameters for summary_sam}

\item{mask}{a clipper mask returned by \code{\link{toClip}} function. It should be set to NULL To avoid clipping, the default.}

\item{clusternames}{The name of the clusters, it should match the clusternames list comprised in the \code{\link[=SpectralReference-class]{SpectralReference}} object passed to \code{\link{tile_sam}} or \code{\link{mosaic_sam}}. Mandatory if object is of class \code{\link[=SAM-class]{SAM}} when smooth = TRUE.}

\item{slice}{Which slice of object should be summarized?}

\item{window}{When smooth = TRUE the size of the window for \code{\link{smooth_sam}}.}

\item{smooth}{When object if of class \code{\link[=SAM-class]{SAM}}, should the function silently apply \code{\link{smooth_sam}} before summarizing?.}

\item{temporal}{if TRUE the raster and shape files from which the summary is extracted are written in the working directory.}
}
\value{
A dataframe with three columns showing the cluster number, the area in pixels^2, and the cluster name as character (only if the parameeter clusternames is within the function call). Each row stand for a single particle. The function writes on disk two files "raster_out.tif" which is a raster of the object passed through the object paramenter, and a shape_out "ESRI Shapefile" folder with a shapefile holding a vectorized version of "raster_out.tif".
}
\description{
Summary method for SAM and Smooth objects.
}
\examples{
x <- mosaic_info(base::system.file("extdata/mosaic.dmt", package = "uFTIR"))
mosaic_sam(x, primpke, n_cores = 1)
y <- mosaic_compose(x@path, clusterlist = primpke@clusterlist)
summary_sam(y, clusternames = primpke@clusternames, smooth = FALSE, temporal = TRUE)
}
