% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.twoway.R
\name{print.twoway}
\alias{print.twoway}
\title{Print method for two-way tables}
\usage{
\method{print}{twoway}(x, digits = getOption("digits"), border = 2,
  zapsmall = TRUE, ...)
}
\arguments{
\item{x}{a numeric matrix}

\item{digits}{number of digits to print}

\item{border}{if 0, the components \code{"twoway"} object (\code{"overall", "roweff", "coleff", "residuals"}) are printed separately;
if 1, the row, column and overall effects are joined to the residuals in a single table.
if 2, row, column, overall and residuals are joined, and decorated with horizontal and vertical rules}

\item{zapsmall}{a logical value; if \code{TRUE} small residuals are printed as 0.}

\item{...}{other arguments passed down}
}
\description{
Print method for two-way tables
}
\examples{
data(taskRT)
task.2way <- twoway(taskRT)
print(task.2way)
print(task.2way, border=0)

data(sentRT)
sent.2way <- twoway(sentRT)
print(sent.2way)
print(sent.2way, border=1)

}
\author{
Michael Friendly, Richard Heiberger
}
