% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladder_power.R
\name{ladder_power}
\alias{ladder_power}
\title{Find the nearest ladder-of-powers representation of a power transformation}
\usage{
ladder_power(p)
}
\arguments{
\item{p}{A numeric power, for use as a transformation of a response, y, of the form \eqn{y^p},
where \code{p=0} is interpreted to mean \eqn{log(y)}}
}
\value{
a named list of two elements: \code{power}, the ladder-of-power value, and
        \code{name}, the name for the transformation
}
\description{
The input power value is rounded to the nearest integer or fractional powers, \eqn{\pm 1/3, 1/2}.
The function is presently designed just for display purposes.
}
\details{
In use, the transformation via the ladder of powers usually attaches a minus sign to
      the transformation when the \code{power < 0}, so that the order of the response values
      are preserved under the transformation. Thus, a result of \code{power = -0.5} is interpreted
      to mean \eqn{-1 / \sqrt{y}}.
}
\examples{
ladder_power(0.6)
ladder_power(-0.6)
}
\references{
Tukey, J. W. (1977). \emph{Exploratory Data Analysis}, Reading MA: Addison-Wesley.
}
