% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RV}
\alias{RV}
\title{Daily realized variance}
\format{A data frame with 4530 rows and 9 variables.
\describe{
  \item{Date}{Daily data from Jan 2, 1990 until Dec 19, 2007 - without
  weekends and days off}
  \item{RVt}{Daily realized variance at time t}
  \item{RVt_1_pos}{Positive daily realized variance at time t-1}
  \item{RVt_1_neg}{Negative daily realized variance at time t-1}
  \item{RVt_1_5}{Weekly realized variance at time t-1}
  \item{RVt_1_22}{Monthly realized variance at time t-1}
  \item{RQt_1_sqrt}{Daily squared root of the realized quarticity at time t-1}
}}
\description{
A dataset containing the daily realized variance, and some of its lags,
obtained from 1-minute close prices of the S\&P 500. Similar data has
been used in the HAR model in Corsi (2009), the HARQ and SHARQ models in
Bollerslev et al (2016) and the tvHARQ and tvSHARQ models in 
Casas et al (2018). The time period runs from Jan 1990 until 
Dec 2007 as in Bollerslev et al (2009).
}
\references{
Bollerslev, T., Patton, A. J. and Quaedvlieg, R. (2016) Exploiting the 
errors: A simple approach for improved volatility forecasting. 
\emph{Journal of Econometrics}, 192, 1-18.

Bollerslev, T., Tauchen, G. and Zhou, H. (2009) Expected stock returns 
and variance risk premia. \emph{The Review of Financial Studies}, 22, 44-63.

Casas, I., Mao, X. and Vega, H. (2018) Reexamining financial and economic 
predictability with new estimators of realized variance and variance 
risk premium. Url= http://pure.au.dk/portal/files/123066669/rp18_10.pdf

Corsi, F. (2009) A simple approximate long-memory model of realized 
volatility. \emph{Journal of Financial Econometrics}, 7, 174-196.
}
\keyword{datasets}
