% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R, R/plot_tvsystem.R, R/tvCov.R,
%   R/tvIRF.R, R/tvOLS.R, R/utils.R
\name{tvReg-internals}
\alias{tvReg-internals}
\alias{.kernel}
\alias{tvReg-internals}
\alias{.univariatePlot}
\alias{tvReg-internals}
\alias{.tvCov.cv}
\alias{.tvIRF}
\alias{.tvOLS.cv}
\alias{tvsure.control}
\title{tvReg internal and secondary functions}
\usage{
.kernel(x, bw, tkernel = "Epa", N = 1)

.univariatePlot(x)

.tvCov.cv(bw, x, est = c("lc", "ll"), tkernel = c("Epa", "Gaussian"))

.tvIRF(x, impulse, response, y.names, n.ahead, ortho, ortho.cov, bw.cov,
  cumulative)

.tvOLS.cv(bw, x, y, z = NULL, est = c("lc", "ll"), tkernel = c("Epa",
  "Gaussian"), singular.ok = TRUE)

tvsure.control(maxiter = 1, tol = 1e-05)
}
\arguments{
\item{x}{A numeric vector.}

\item{bw}{A scalar.}

\item{tkernel}{A character, either "Epa" (default) or "Gaussian".}

\item{N}{A scalar, in case we want to make the bandwidth smaller.}

\item{est}{A character, either "lc" or "ll" for local constant or local linear.}

\item{maxiter}{maximum number of iterations for the iterative FGLS
estimations.}

\item{tol}{tolerance level indicating when to stop the iteration for the iterative FGLS estimations}

\item{x}{A matrix.}

\item{bw}{A scalar.}

\item{tkernel}{A character, either "Gaussian" or "Epa" kernel types.}
}
\value{
A numeric vector.

A scalar with the mean squared error.

A list of the above components.
}
\description{
Listed below are supporting functions for the major methods in tvReg.

Create a list of control pararameters for function \code{\link{tvSURE}}.
All control parameters that are not passed to this function are set to
default values.
}
\details{
.kernel calculates the kernel values of a vector and a given bandwidth

If the estimation is iterative FGLS with \code{maxiter}>1, the convergence criterion is
\deqn{\sqrt{ \frac{ \sum_{i, j}
(B_{i,j,g} - B{i, j, g-1})^2 }{ \sum_{i, j} B_{i, j, g-1}^2 }} < \code{tol}}
(\eqn{B_{i, j,g}} is the ith, jth coefficient of the gth iteration step).
}
\keyword{internal}
