% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tuar1redf.R
\name{plot.tuts_ar1redf}
\alias{plot.tuts_ar1redf}
\title{Plots and visual diagnostics of tuts_ar1redf objects}
\usage{
\method{plot}{tuts_ar1redf}(x, type, ...)
}
\arguments{
\item{x}{A tuts_tuar1 objects.}

\item{type}{plot type with the following options:\cr
- 'predTUTS' plots one step predictions of the model. \cr
- 'par' plots distributions of parameters of the model. \cr
- 'tau' plots realizations of time persistence. \cr
- 'GR' plots Gelman-Rubin diagnostics. \cr
- 'cv' plots 5-fold cross validation. \cr
- 'mcmc' plots diagnostics of MCMC/JAGS objects. \cr}

\item{...}{list of optional parameters: \cr
- burn: burn-in parameter ranging from 0 to 0.7 with default value set to 0. \cr
- CI: credible interval ranging from 0.3 to 1 with default value set to 0.95.}
}
\description{
\code{plot.tuts_ar1redf} generates plots and visual diagnostics of tuts_ar1redf objects.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN's testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=10,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=1000; n.chains=2
AR1REDF=tuar1redf(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=n.sim,n.chains=n.chains,CV=TRUE,n.cores=2)

#3. Generate plots and diagnostics of the model (optional parameters are listed in brackets):
plot(AR1REDF,type='predTUTS',burn=0.2,CI=0.99)  # One step out of salmple predictions (CI, burn).
plot(AR1REDF,type='par', burn=0.4)              # Distributions of parameters (burn).
plot(AR1REDF,type='mcmc')                       # MCMC diagnostics.
plot(AR1REDF,type='cv', burn=0.4)               # 5 fold cross validation (CI, burn).
plot(AR1REDF,type='GR', burn=0.4)               # Gelman-Rubin diagnostic (CI, burn).
plot(AR1REDF,type='tau')                        # realizations of persistence of time.

}
