% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vrf.R
\name{vrf}
\alias{vrf}
\title{Compute the frequency-specific variance ratio}
\usage{
vrf(X)
}
\arguments{
\item{X}{a matrix with counts or densities arranged in species by time step}
}
\value{
\code{vrf} returns a list consisting of
\item{frequency}{a vector from 0 to 1 (not including 0 and 1)}
\item{vr}{a vector of frequency-specific or frequency-decomposition of VR}
}
\description{
This function computes the frequency-specific variance ratio for a community in a single plot.
}
\examples{
X<-matrix(runif(200,1,100), 10, 20)
ans<-vrf(X)

}
\references{
<Lei's paper>
}
\seealso{
\code{\link{vr}}
}
\author{
Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
