% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvreq_classic.R
\name{tsvreq_classic}
\alias{tsvreq_classic}
\title{Creator function for the \code{tsvreq_classic} S3 class}
\usage{
tsvreq_classic(X)
}
\arguments{
\item{X}{a matrix with counts or densities arranged in species by time step}
}
\value{
\code{tsvreq_classic} returns a \code{tsvreq_classic} object. Slots are:
\item{ts}{a vector of timescales}
\item{com}{a timescale-specific decomposition of CVcom2}
\item{comnull}{a timescale-specific decomposition of CVcomip2}
\item{tsvr}{a timescale-specific version of the classic variance ratio}
\item{wts}{a vector of weights, same length as all the above}
}
\description{
The \code{tsvreq_classic} (timescale-specific variance ratio equation, classic variance
ratio) class is for storing functional equations based on a timescale specific version of
the classic variance ratio. Inherits from \code{tsvreq}, which inherits from \code{list}.
}
\examples{
X<-matrix(runif(10*100),10,100)
res<-tsvreq_classic(X)

}
\references{
Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.
}
\seealso{
\code{\link{tsvreq_classic_methods}}, \code{\link{tsvreq}}, \code{\link{vreq_classic}}, 
\code{browseVignettes("tsvr")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
