% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmav.R
\name{cmav}
\alias{cmav}
\title{Centred moving average}
\usage{
cmav(y, ma = NULL, fill = c(TRUE, FALSE), outplot = c(FALSE, TRUE),
  fast = c(TRUE, FALSE))
}
\arguments{
\item{y}{input time series. Can be \code{ts} or \code{msts} object.}

\item{ma}{length of centred moving average. If \code{y} is a \code{ts} object then the default is its frequency. If it is a \code{msts} object the default is the maximum frequency.}

\item{fill}{if \code{TRUE}, then fill first and last ma/2 observations using exponential smoothing.}

\item{outplot}{if \code{TRUE}, then output a plot of the time series and the moving average.}

\item{fast}{if \code{TRUE}, then only a limited set of models are evaluated for CMA extrapolation.}
}
\value{
Centred moving average. If y is a ts object, then cma has the same properties.
}
\description{
Calculate the Centred Moving Average (CMA) for time series.
}
\examples{
cmav(referrals,outplot=TRUE)

}
\references{
Ord K., Fildes R., Kourentzes N. (2017) \href{http://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting, 2e}. \emph{Wessex Press Publishing Co.}, p.109.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{cma}
\keyword{ts}
