% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendtest.R
\name{trendtest}
\alias{trendtest}
\title{Test a time series for trend}
\usage{
trendtest(y, extract = c("FALSE", "TRUE"), type = c("aicc", "cs"),
  mta = c(FALSE, TRUE))
}
\arguments{
\item{y}{a time series that must be of either \code{ts} or \code{msts} class.}

\item{extract}{if \code{TRUE} then the centred moving average of the time series is calculated and the test is performed on that. Otherwise, the test is performed on the raw data.}

\item{type}{type of test. Can be:
\itemize{
\item{\code{"aicc"}}{: test by comparing the AICc of exponential smoothing models. See details.}
\item{\code{"cs"}}{: test by using the Cox-Stuart test. See details.}
}}

\item{mta}{If \code{TRUE} augment testing by using Multiple Temporal Aggregation.}
}
\value{
The function returns \code{TRUE} when there is evidence of trend and \code{FALSE} otherwise.
}
\description{
Test a time series for trend by either fitting exponential smoothing models and comparing then using the AICc, or by using the non-parametric Cox-Stuart test. The tests can be augmented by using multiple temporal aggregation.
}
\details{
All tests are performed at 5% significance level. When exponential smoothing is used the following three models are compared: ETS(A,N,N), ETS(A,A,N), ETS(A,Ad,N).
}
\examples{
trendtest(referrals,TRUE)

}
\references{
The multiple temporal aggregation follows the construction approach suggested by Kourentzes, N., Petropoulos, F., & Trapero, J. R. (2014). \href{http://kourentzes.com/forecasting/2014/04/19/improving-forecasting-by-estimating-time-series-structural-components-across-multiple-frequencies/}{Improving forecasting by estimating time series structural components across multiple frequencies}. International Journal of Forecasting, 30(2), 291-302.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{htest}
