% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdaseq.R
\name{lambdaseq}
\alias{lambdaseq}
\title{Generate sequence of lambda for LASSO regression}
\usage{
lambdaseq(x, y, weight = NA, alpha = 1, standardise = TRUE,
  lambdaRatio = 1e-04, nLambda = 100, addZeroLambda = FALSE)
}
\arguments{
\item{x}{matrix of regressors. See \code{\link[glmnet]{glmnet}}.}

\item{y}{response variable. See \code{\link[glmnet]{glmnet}}.}

\item{weight}{vector of \code{length(nrow(y))} for weighted LASSO estimation. See \code{\link[glmnet]{glmnet}}.}

\item{alpha}{elastic net mixing value. See \code{\link[glmnet]{glmnet}}.}

\item{standardise}{if \code{TRUE}, then variables are standardised.}

\item{lambdaRatio}{ratio between \code{lambdaMax} and \code{lambdaMin}. That is, \code{lambdaMin <- lambdaMax * lambdaRatio}.}

\item{nLambda}{length of the lambda sequence.}

\item{addZeroLambda}{if \code{TRUE}, then set the last value in the lambda sequence to 0, which is the OLS solution.}
}
\value{
A list that contains:
\itemize{
\item{lambda}{: sequence of lambda values, from \code{lambdaMax} to \code{lambdaMin}.}
\item{lambdaMin}{: minimal lambda value.}
\item{lambdaMax}{: maximal lambda value.}
\item{nullMSE}{: MSE of the fit using just a constant term.}
}
}
\description{
Calculates the \code{lambdaMax} value, which is the penalty term (lambda) beyond which coefficients are guaranteed to be all zero and provides a sequence of \code{nLambda} values to \code{lambdaMin} in logarithmic descent.
}
\examples{
y <- mtcars[,1]
x <- as.matrix(mtcars[,2:11])
lambda <- lambdaseq(x, y)$lambda

\dontrun{
  library(glmnet)
  fit.lasso <- cv.glmnet(y, x, lambda = lambda)
  coef.lasso <- coef(fit.lasso, s = "lambda.1se")
}

}
\references{
Hastie, T., Tibshirani, R., & Wainwright, M. (2015). Statistical learning with sparsity: the lasso and generalizations. CRC press.
}
\author{
Oliver Schaer, \email{info@oliverschaer.ch},

Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{Regression}
\keyword{ts}
