% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_data_cleaning.R
\name{auto_data_cleaning}
\alias{auto_data_cleaning}
\title{Perform automatic data cleaning of time series data}
\usage{
auto_data_cleaning(
  data,
  S,
  tau = NULL,
  no.of.last.indices.to.fix = S[1],
  indices.to.fix = NULL,
  model.missing.pars = list(),
  detect.outliers.pars = list()
)
}
\arguments{
\item{data}{an input vector, matrix or data frame of dimension nobs x nvars
containing missing values; each column is a variable.}

\item{S}{a number or vector describing the seasonalities (S_1, ..., S_K) in
the data, e.g. c(24, 168) if the data consists of 24 observations per day
and there is a weekly seasonality in the data.}

\item{tau}{the quantile(s) of the missing values to be estimated in the
quantile regression. Tau accepts all values in (0,1). If NULL, then the
weighted lasso regression is performed.}

\item{no.of.last.indices.to.fix}{a number of observations in the tail of
the data to be fixed, by default set to S.}

\item{indices.to.fix}{indices of the data to be fixed. If NULL, then it is
calculated based on the no.of.last.indices.to.fix parameter. Otherwise, the
no.of.last.indices.to.fix parameter is ignored.}

\item{model.missing.pars}{named list containing additional arguments for the
\link[tsrobprep]{model_missing_data} function.}

\item{detect.outliers.pars}{named list containing additional arguments for
the \link[tsrobprep]{detect_outliers} function.}
}
\value{
A list which contains a matrix or a list of matrices with imputed
missing values or outliers, the indices of the data that were modelled, and
the given quantile values.
}
\description{
Returns a matrix or a list of matrices with imputed missing values and
outliers. The function automatizes the usage of functions
\link[tsrobprep]{model_missing_data}, \link[tsrobprep]{detect_outliers} and
\link[tsrobprep]{impute_modelled_data}. The function is designed for
numerical data only.
}
\details{
The function calls \link[tsrobprep]{model_missing_data} to clean
the data from missing values, \link[tsrobprep]{detect_outliers} to detect
outliers, removes them and finally applies again
\link[tsrobprep]{model_missing_data} function. For details see the
functions' respective help sections.
}
\examples{
\dontrun{
autoclean <- auto_data_cleaning(
  data = GBload[,-1], S = c(48, 7*48),
  no.of.last.indices.to.fix = dim(GBload)[1],
  model.missing.pars = list(consider.as.missing = 0, min.val = 0)
)
autoclean$replaced.indices
}
}
\seealso{
\code{\link[tsrobprep]{model_missing_data}},
\link[tsrobprep]{detect_outliers}, \link[tsrobprep]{impute_modelled_data}
}
