% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdts-predict.R
\name{sdts_predict}
\alias{sdts_predict}
\title{Framework for Scalable Dictionary learning for Time Series (SDTS) prediction function}
\usage{
sdts_predict(model, data, window_size)
}
\arguments{
\item{model}{a model created by SDTS training function \code{\link[=sdts_train]{sdts_train()}}.}

\item{data}{a \code{vector} of \code{numeric}. Time series.}

\item{window_size}{an \code{int}. The average sliding window size.}
}
\value{
Returns a \code{vector} of \code{logical} with predicted annotations.
}
\description{
This function trains a model that uses a dictionary to predict state changes. Differently from
\code{\link[=fluss]{fluss()}}, it doesn't look for semantic changes (that may be several), but for binary states like
"on" or "off". Think for example that a human annotator is pressing a switch any time he thinks
that the recorded data is relevant, and releases the switch when he thinks the data is noise. This
algorithm will learn the switching points (even better) and try to predict using new data.
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#' Not run' section below.
w <- c(110, 220)
subs <- 11000:20000
tr_data <- mp_test_data$train$data[subs]
tr_label <- mp_test_data$train$label[subs]
te_data <- mp_test_data$test$data[subs]
te_label <- mp_test_data$test$label[subs]
model <- sdts_train(tr_data, tr_label, w, verbose = 0)
predict <- sdts_predict(model, te_data, round(mean(w)))
sdts_score(predict, te_label, 1)
\dontrun{
windows <- c(110, 220, 330)
model <- sdts_train(mp_test_data$train$data, mp_test_data$train$label, windows, verbose = 0)
predict <- sdts_predict(model, mp_test_data$test$data, round(mean(windows)))
sdts_score(predict, mp_test_data$test$label, 1)
}

}
\references{
\itemize{
\item Yeh C-CM, Kavantzas N, Keogh E. Matrix profile IV: Using Weakly Labeled Time Series
to Predict Outcomes. Proc VLDB Endow. 2017 Aug 1;10(12):1802-12.
}

Website: \url{https://sites.google.com/view/weaklylabeled}
}
\seealso{
Other Scalable Dictionaries: 
\code{\link{sdts_score}()},
\code{\link{sdts_train}()}
}
\concept{Scalable Dictionaries}
