% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdts-predict.R
\name{sdts_score}
\alias{sdts_score}
\title{Computes the F-Score of a SDTS prediction}
\usage{
sdts_score(gtruth, pred, beta = 1)
}
\arguments{
\item{gtruth}{a \code{vector} of \code{logical}. Ground truth annotation.}

\item{pred}{a \code{vector} of \code{logical}. Predicted annotation from \code{\link[=sdts_predict]{sdts_predict()}}}

\item{beta}{a \code{numeric}. See details. (default is \code{1}).}
}
\value{
Returns a \code{list} with \code{f_score}, \code{precision} and \code{recall}.
}
\description{
Computes the F-Score of a SDTS prediction.
}
\details{
\code{beta} is used to balance F-score towards recall (\code{>1}) or precision (\code{<1}).
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- c(110, 220)
subs <- 11000:20000
tr_data <- mp_test_data$train$data[subs]
tr_label <- mp_test_data$train$label[subs]
te_data <- mp_test_data$test$data[subs]
te_label <- mp_test_data$test$label[subs]
model <- sdts_train(tr_data, tr_label, w, verbose = 0)
predict <- sdts_predict(model, te_data, round(mean(w)))
sdts_score(te_label, predict, 1)

\dontrun{
windows <- c(110, 220, 330)
model <- sdts_train(mp_test_data$train$data, mp_test_data$train$label, windows)
predict <- sdts_predict(model, mp_test_data$test$data, round(mean(windows)))
sdts_score(mp_test_data$test$label, predict, 1)
}

}
\references{
\itemize{
\item Yeh C-CM, Kavantzas N, Keogh E. Matrix profile IV: Using Weakly Labeled Time Series
to Predict Outcomes. Proc VLDB Endow. 2017 Aug 1;10(12):1802–12.
}

Website: \url{https://sites.google.com/view/weaklylabeled}
}
\seealso{
Other Scalable Dictionaries: \code{\link{sdts_predict}},
  \code{\link{sdts_train}}
}
\concept{Scalable Dictionaries}
