% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{alpha_6_to_7}
\alias{alpha_6_to_7}
\title{Convert Threshold Values from Six to Seven Point Scale}
\usage{
alpha_6_to_7(thresh = truthiness::clmm_maximal$alpha)
}
\arguments{
\item{thresh}{Log-odds thresholds from a cumulative logit model fit. Should be a five-element vector.}
}
\value{
A six-element vector representing the thresholds on a seven-point scale.
}
\description{
Convert Threshold Values from Six to Seven Point Scale
}
\details{
The basic algorithm is to copy the top and bottom thresholds and then to shrink the spaces between the thresholds on the six-point scale to 80\% of their size. The left over space is allocated to the middle category on the seven-point scale.
}
\examples{
clmm_maximal$alpha # original thresholds
alpha_6_to_7(clmm_maximal$alpha) 
}
