% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/callTrust.R
\name{trust.optim}
\alias{trust.optim}
\title{Nonlinear optimizers using trust regions.}
\usage{
trust.optim(x, fn, gr, hs = NULL, method = c("SR1", "BFGS", "Sparse"),
  control = list(), ...)
}
\arguments{
\item{x}{A numeric vector of starting values for the optimizer.}

\item{fn}{An R function that takes \code{x} as its first argument.
Returns the value of the objective function at \code{x}.
Note that the optimizer will \emph{minimize} \code{fn} (see
function.scale.factor under control)}

\item{gr}{An R function that takes x as its first argument.  Returns a
numeric vector that is the gradient of \code{fn} at \code{x}. The
length of the gradient must be the same as the length of \code{x}.
The user must supply this function.  If an analytic gradient is not
available, and the method is \code{SR1} or \code{BFGS}, the user should consider a
numerical approximation using finite differencing (see the
numDeriv package).  Do not use a finite-differenced gradient with
the \code{Sparse} method.  That will cause a world of hurt.}

\item{hs}{An R function that takes x as its first argument.
Returns a Hessian matrix object of class \code{dgCMatrix} (see the \pkg{Matrix} package).
This function is called only if the selected method is \code{Sparse}.}

\item{method}{Valid arguments are \code{SR1},\code{BFGS},and \code{Sparse}.}

\item{control}{A list containing control parameters for the optimizer.
See details.}

\item{...}{Additional arguments passed to \code{fn}, \code{gr} and \code{hs}.
  All arguments must be named.}
}
\value{
List containing the following items:
  \item{fval}{Value of the objective function}
  \item{solution}{Parameter vector at the optimum}
  \item{gradient}{Gradient at the optimum}
  \item{hessian}{Estimate of the Hessian at the optimum (as class
    \code{symmetricMatrix}, returned only for \code{Sparse} method).}
  \item{iterations}{Number of iterations before stopping}
  \item{status}{A message describing the last state of the iterator}
  \item{nnz}{For the Sparse method only, the number of nonzero elements in the lower triangle of the Hessian}.
}
\description{
Run nonlinear minimizer using trust region algorithm with conjugate
gradient search directions and quasi-Hessian updates.
}
\section{Details}{

 The following sections explain how to use the package as a whole.
}

\section{Control parameters}{

The control list should include the following parameters.
\describe{
\item{start.trust.radius}{Initial radius of the trust region. Default is 5.  If the algorithm returns non-finite values of the objective function early in the process, try a lower number.}
\item{stop.trust.radius}{Minimum radius of trust region.  Algorithm will terminate if radius is below this value.  This is because it may not be possible to get the norm of the gradient smaller than prec, and this is another way to get the algorithm to stop.}
\item{cg.tol}{tolerance for the conjugate gradient algorithm that is used for the trust region subproblem.  Set it to something very small.  Default is sqrt(.Machine$double.eps)}
\item{prec}{Precision for how close the norm of the gradient at the
    solution should be to zero, before the algorithm halts.  It is possible that the algorithm
    will not get that far, so it will also stop when the radius of the
    trust region is smaller thanstop.trust.radius.  If the trust
    region radius collapses, but the norm of the gradient really isn't
    close to zero, then something terrible has happened.}
\item{report.freq}{An integer. The frequency at which the algorithm
  will display the current iteration number or function value, among
  other things (see \code{report.level}).  Defaults to 1.}
\item{report.level}{The amount of detail in each report.  Defaults to 2.}
\item{report.precision}{The number of significant digits used in each
    report. Defaults to 5.}
\item{maxit}{Maximum number of iterations.  Defaults to 100.}
\item{contract.factor}{When the algorithm decides to shrink the trust
    region, it will multiply the trust radius by this factor. Defaults to 0.5.}
\item{expand.factor}{When the algorithm decides to expand the trust
    region, it will multiply the algorithm by this factor. Defaults to 3.}
\item{contract.threshold}{The algorithm with accept a proposed move if the ratio of the actual improvement in the objective function, to the predicted improvement from the trust region subproblem, is greater than this amount.  Otherwise, the trust region will contract.  Default is 0.25.}
\item{expand.threshold.ap}{First criterion to determine if the trust region should expand.  If the ratio of the actual and proposed improvements in the objective function is less than this factor, the algorithm will consider expanding the trust region.  See \code{expand.threshold.radius}. Default is 0.8.}
\item{expand.threshold.radius}{If the ratio of the actual and proposed improvement in the objective function is less than \code{expand.threshold.ap}, then, if the normed distance of the proposed move is greater than  \code{expand.threshold.radius}, times the current trust region radius, the trust region will expand.  Default is 0.8.}
\item{function.scale.factor}{The algorithm will minimize \code{fn} times this
    factor. If you want to maximize \code{fn}, this value should be negative
    (usually -1).  Default is 1.}
\item{precond.refresh.freq}{Frequency at which the preconditioner
    for the conjugate gradiate estimation of the trust region
    subproblem is reestimated.  Preconditioners can help the convergence properties of the algorithm.  Default is 1.}
\item{preconditioner}{ID for choice of preconditioner.  0 is the
    identity matrix (default), For the \code{Sparse} method, 1 is a modified Cholesky preconditioner. For the \code{BFGS} method, 1 is the full Cholesky decomposition.  If you select 1 for the \code{SR1} method, the algorithm will use the identity preconditioner instead.}
\item{trust.iter}{Maximum number of conjugate gradient iterations to run when solving the trust region subproblem.  A higher number will lead to more accurate solutions to the subproblem, but may also lead to longer run times. Defaults to 2000.}
}
}

\section{Report levels}{

The \code{report.level} control parameter determines how much information is displayed each time the algorithm reports the current state.  Possible values are

\describe{
\item{<=0}{No information (a quiet run)}
\item{1}{Current iteration number, and current value of the objective function.}
\item{2}{Information from level 1, plus the current norm of the gradient and a status message.}
\item{3}{Information from levels 1 and 2, plus the current normed radius of the trust region.}
\item{4}{Information from levels 1, 2, and 3, plus information from each estimate of the trust region subproblem (number of conjugate gradient iterations and how/why the CG algorithm terminated).}
}

Default level is 2.  Levels 3 and 4 are available primarily for debugging purposes.
}

\section{Stopping criteria}{

The algorithm will stop when one of the following three conditions are met:
\itemize{
\item{The norm of the gradient, divided by the square root of the number of parameters, is less than \code{prec}.}
\item{The trust region collapse to a radius smaller than machine precision}
\item{The algorithm proposes zero or negative improvement in the objective function (should never happen)}
\item{The number of iterations reaches the control parameter \code{maxit}}
}

If the algorithm appears to have stopped prematurely (i.e., the norm of the gradient is still too large), then one might just restart the algorithm.  For the quasi-Newton algorithms (\code{SR1} and \code{BFGS}), this will refresh the Hessian, and might allow more progress to be made.
}

\section{Estimating a sparse Hessian}{

Sometimes estimating the Hessian is easy (e.g., you have an analytic representation, or you are using some kind of algorithmic differentiation software).  If you do not know the Hessian, but you do know the sparsity structure, try the \pkg{sparseHessianFD} package. The routines in \pkg{sparseHessianFD} compute the Hessian using finite differencing, but in a way that exploits the sparsity structure.  In many cases, this can be faster than constructing an analytic Hessian for a large problem (e.g., when the Hessian has a block-arrow structure with a large number of blocks).

To use the \pkg{sparseHessianFD} package, you need to provide the row and column indices of the non-zero elements of the lower triangle of the Hessian. This structure cannot change during the course of the trust.optim routine.  Also, you really should provide an analytic gradient.  \pkg{sparseHessianFD} computes finite differences of the gradient, so if the gradient itself is finite-differenced, so much error is propagated through that the Hessians are nearly worthless close to the optimum.

Of course, \pkg{sparseHessianFD} is useful only for the \code{Sparse} method.  That said, one may still get decent performance using these routines even if the Hessian is sparse, if the problem is not too large.  Just treat the Hessian as if it were sparse.
}

