\name{Demonstration functions}
\alias{demo.get.f}
\alias{demo.get.f.dense}
\alias{demo.get.grad}
\alias{demo.get.grad.dense}
\alias{.demo.dlog.f.db}
\alias{.demo.dlog.f.dmu}
\alias{demo.get.hess.struct}
\alias{demo.trust.func}
\title{Functions used in the binary choice demo}
\description{
These are functions that define the objective functions and gradients for the 
demo examples in the vignette.  They should not be called directly.}
\usage{
demo.get.f(pars, Y, X, inv.Omega, inv.Sigma, T)
demo.get.f.dense(pars, Y, X, inv.Omega, T)
demo.get.grad(pars, Y, X, inv.Omega, inv.Sigma, T)
demo.get.grad.dense(pars, Y, X, inv.Omega, T)
.demo.dlog.f.db(pars, Y, X, inv.Omega, inv.Sigma, T)
.demo.dlog.f.dmu(pars, Y, X, inv.Omega, inv.Sigma)
demo.get.hess.struct(N,k)
demo.trust.func(pars, obj,...)
}
\arguments{
	\item{pars}{input parameters}
	\item{Y}{data}
	\item{X}{data}
	\item{inv.Sigma}{prior parameter}
	\item{inv.Omega}{prior parameter}
	\item{T}{number of observations per unit}
	\item{N}{number of individual units}
	\item{k}{length of individual parameter vector}
	\item{obj}{object generated by sparseHessianFD package}
	\item{...}{Additional arguments}
}
\details{
These are functions that define the objective functions and gradients for the 
demo examples in the vignette.  They should not be called directly.  See vignette for more details.
}






 


