% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{trackDistance}
\alias{trackDistance}
\alias{trackDistance.default}
\alias{trackDistance.trip}
\title{Determine distances along a track}
\usage{
trackDistance(x1, y1, x2, y2, longlat = TRUE, prev = FALSE)
}
\arguments{
\item{x1}{trip object, matrix of 2-columns, with x/y coordinates OR a vector
of x start coordinates}

\item{y1}{vector of y start coordinates, if x1 is not a matrix}

\item{x2}{vector of x end coordinates, if x1 is not a matrix}

\item{y2}{vector of y end coordinates, if x1 is not a matrix}

\item{longlat}{if FALSE, Euclidean distance, if TRUE Great Circle distance}

\item{prev}{if TRUE and x1 is a trip, the return value has a padded end
value (\"prev\"ious), rather than start (\"next\")}
}
\value{
Vector of distances between coordinates.
}
\description{
Calculate the distances between subsequent 2-D coordinates using Euclidean
or Great Circle distance (WGS84 ellipsoid) methods.
}
\details{
If \code{x1} is a trip object, arguments \code{x2}, \code{x3}, \code{y2} are
ignored and the return result has an extra element for the start point of
each individual trip, with value 0.0.

The \code{prev} argument is ignore unless x1 is a trip.

Distance values are in the units of the input coordinate system when longlat
is FALSE, and in kilometres when longlat is TRUE.

This originally used \code{\link[sp]{spDistsN1}}, then implemented the sp
\code{gcdist} source directly in R, and now uses \code{\link[geodist]{geodist}}.

Please see the traipse package for a more modern approach.
}
\examples{
 d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
 tr <- trip(d, c("tms", "id"))

 ## the method knows this is a trip, so there is a distance for every
 ## point, including 0s as the start and at transitions between
 ## individual trips
trackDistance(tr)

## the default method does not know about the trips, so this is
##(n-1) distances between all points
trackDistance(coordinates(tr), longlat = FALSE)

## we get NA at the start, end and at transitions between trips

 angles <- trackAngle(walrus818)
}
\references{
Original source taken from sp package, but now using Helmert from Karney (2013)
see the geodist package.
}
