% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox_superiority.R
\name{efftox_superiority}
\alias{efftox_superiority}
\title{Get dose-superiority matrix in EffTox}
\usage{
efftox_superiority(fit)
}
\arguments{
\item{fit}{An instance of \code{efftox_fit}.}
}
\value{
n by n matrix, where n is number of doses under investigation.
The item in row i, col j is the posterior probability that the utility of
dose j exceeds that of dose i.
}
\description{
Get a dose-superiority matrix from an EffTox dose analysis.
EffTox seeks to choose the dose with the highest utility, thus superiority
is inferred by posterior utility. The item in row i, col j is the posterior
probability that the utility of dose j exceeds that of dose i.
}
\examples{
fit <- stan_efftox_demo('1N 2E 3B')
sup_mat <- efftox_superiority(fit)
}
