% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosefinding.R
\name{parse_dose_finding_outcomes}
\alias{parse_dose_finding_outcomes}
\title{Parse a string of dose-finding trial outcomes.}
\usage{
parse_dose_finding_outcomes(outcome_string)
}
\arguments{
\item{outcome_string}{character representing doses given, outcomes
observed, and timing of analyses. See Description.}
}
\value{
a list with a slot for each cohort. Each cohort slot is itself a
list, containing elements:
* \code{dose}, the integer dose delivered to the cohort;
* \code{outcomes}, a character string representing the \code{T} or \code{N}
 outcomes for the patients in this cohort.
}
\description{
Parse a string of dose-finding trial outcomes

Parse a string of dose-finding trial outcomes to a list.
The outcome string describes the doses given, outcomes observed and the
timing of analyses that recommend a dose. The format of the string is
the pure phase I analogue to that described in Brock _et al_. (2017).
The letters T and N are used to represents patients that experienced
(T)oxicity and (N)o toxicity. These letters are concatenated after numerical
dose-levels to convey the outcomes of cohorts of patients.
For instance, \code{2NNT} represents a cohort of three patients that were
treated at dose-level 2, one of whom experienced toxicity, and two that did
not. The results of cohorts are separated by spaces and it is assumed that a
dose-finding decision takes place at the end of a cohort. Thus,
\code{2NNT 1NN} builds on our previous example, where the next cohort of two
were treated at dose-level 1 and neither of these patients experienced
toxicity. See examples.
}
\examples{
x = parse_dose_finding_outcomes('1NNN 2NNT 3TT')
length(x)
x[[1]]$dose
x[[1]]$outcomes
x[[2]]$dose
x[[2]]$outcomes
x[[3]]$dose
x[[3]]$outcomes

}
\references{
Brock, K., Billingham, L., Copland, M., Siddique, S., Sirovica, M., & Yap, C.
(2017). Implementing the EffTox dose-finding design in the Matchpoint trial.
BMC Medical Research Methodology, 17(1), 112.
https://doi.org/10.1186/s12874-017-0381-x
}
