% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pettitt.test.R
\name{pettitt.test}
\alias{pettitt.test}
\title{Pettitt's Test for Change-Point Detection}
\usage{
pettitt.test(x)
}
\arguments{
\item{x}{a vector of class "numeric" or a time series object of class "ts"}
}
\value{
A list with class "htest" and "cptest"
}
\description{
Performes a non-parametric test after Pettitt in order to test for a
shift in the central tendency of a time series. The H0-hypothesis,
no change, is tested against the HA-Hypothesis, change.
}
\details{
In this function, the test is implemented as given by Verstraeten et. al.
(2006), where the ranks \eqn{r_1, \ldots, r_n}{r[1], ..., r[n]} of
the \eqn{X_i, \ldots, X_n}{X[i], ..., X[n]} are used for the statistic:

\deqn{U_k = 2 \sum_{i=1}^k r_i - k \left(n + 1\right) \qquad k = 1, \ldots, n}{%
U[k] = 2 * \sum r_i - k (n + 1)   k = 1, ..., n}

The test statistic is the maximum of the absolute value of the vector:

\deqn{\hat{U} = \max |U_k|}{U* = max |P[k]|}.

The probable change-point \eqn{K} is located where \eqn{\hat{U}}{U*} has its maximum.
The approximate probability for a two-sided test is calculated
according to 

\deqn{p = 2 \exp^{-6K^2 / (T^3 + T^2)}}{%
  p =2 exp[-6K^2 / (T^3 + T^2)].}
}
\note{
The current function is for complete observations only.
 The approximate probability is good for \eqn{p \le 0.5}.
}
\examples{
data(maxau) ; plot(maxau[,"s"])
s.res <- pettitt.test(maxau[,"s"])
n <- s.res$nobs
i <- s.res$estimate
s.1 <- mean(maxau[1:i,"s"])
s.2 <- mean(maxau[(i+1):n,"s"])
s <- ts(c(rep(s.1,i), rep(s.2,(n-i))))
tsp(s) <- tsp(maxau[,"s"])
lines(s, lty=2)
print(s.res)


data(PagesData) ; pettitt.test(PagesData)
 
}
\references{
CHR (ed., 2010), Das Abflussregime des Rheins und seiner Nebenfluesse im
20. Jahrhundert, Report no I-22 of the CHR, p. 172.

Pettitt, A. N. (1979), A non-parametric approach to the change point
problem. \emph{Journal of the Royal Statistical Society Series C}, Applied
Statistics 28, 126-135.

G. Verstraeten, J. Poesen, G. Demaree, C. Salles (2006),
Long-term (105 years) variability in rain erosivity as derived from 10-min
rainfall depth data for Ukkel (Brussels, Belgium):
Implications for assessing soil erosion rates.
\emph{Journal of Geophysical Research} 111, D22109.
}
\seealso{
\code{\link[strucchange]{efp}}
\code{\link[strucchange]{sctest.efp}}
}
\keyword{htest}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
