% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog.R
\name{cog}
\alias{cog}
\title{Cast Column as a Cognostic}
\usage{
cog(
  val = NULL,
  desc = "",
  group = "common",
  type = NULL,
  default_label = FALSE,
  default_active = TRUE,
  filterable = TRUE,
  sortable = TRUE,
  log = NULL
)
}
\arguments{
\item{val}{a scalar value (numeric, character, date, etc.)}

\item{desc}{a description for this cognostic value}

\item{group}{optional categorization of the cognostic for organizational purposes in the viewer (currently not implemented in the viewer)}

\item{type}{the desired type of cognostic you would like to compute (see details)}

\item{default_label}{should this cognostic be used as a panel label in the viewer by default?}

\item{default_active}{should this cognostic be active (available for sort / filter / sample) by default?}

\item{filterable}{should this cognostic be filterable?  Default is \code{TRUE}.  It can be useful to set this to \code{FALSE} if the cognostic is categorical with many unique values and is only desired to be used as a panel label.}

\item{sortable}{should this cognostic be sortable?}

\item{log}{when being used in the viewer for visual univariate and bivariate filters, should the log be computed?  Useful when the distribution of the cognostic is very long-tailed or has large outliers.  Can either be a logical or a positive integer indicating the base.}
}
\value{
object of class "cog"
}
\description{
Cast a column of a cognostics data frame as a cognostic object
}
\details{
Different types of cognostics can be specified through the \code{type} argument that will affect how the user is able to interact with those cognostics in the viewer.  This can usually be ignored because it will be inferred from the implicit data type of \code{val}.  But there are special types of cognostics, such as geographic coordinates and relations (not implemented) that can be specified as well.  Current possibilities for \code{type} are "key", "integer", "numeric", "factor", "date", "time", "href".
}
\examples{
library(dplyr)
library(tidyr)
library(purrr)
library(ggplot2)
library(rbokeh)

mpg_cog <- mpg \%>\%
  group_by(manufacturer, class) \%>\%
  nest() \%>\%
  mutate(
    cogs = map_cog(data, ~ tibble(
      mean_city_mpg = cog(mean(.$cty), desc = "Mean city mpg"),
      mean_hwy_mpg = cog(mean(.$hwy), desc = "Mean highway mpg"),
      most_common_drv = cog(tail(names(table(.$drv)), 1), desc = "Most common drive type")
    )),
    panel = map_plot(data, ~
      figure(., xlab = "City mpg", ylab = "Highway mpg",
        xlim = c(9, 47), ylim = c(7, 37)) \%>\%
        ly_points(cty, hwy,
          hover = list(year, model))
    )
  )

trelliscope(mpg_cog, name = "city_vs_highway_mpg", nrow = 1, ncol = 2)
}
