% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{reorder}
\alias{reorder}
\alias{reorder.treedata}
\title{Reorder a \code{treedata} object}
\usage{
reorder(tdObject, ...)

\method{reorder}{treedata}(tdObject, order = "postorder", index.only = FALSE, ...)
}
\arguments{
\item{tdObject}{An object of class \code{treedata}}

\item{...}{Additional arguments to reorder.phylo}

\item{order}{Method for reordering}

\item{index.only}{Whether a index is returned rather than the reordered treedata object}
}
\value{
An object of class \code{treedata}
}
\description{
Reorders a \code{treedata} object. Both the tips and the data are automatically reordered to match.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat)
td <- reorder(td, "postorder")
}
\seealso{
\code{\link{reorder.phylo}}
}
