% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treemapify.R, R/treemapify_fixed.R
\name{treemapify}
\alias{treemapify}
\alias{treemapify_fixed}
\title{Generate a treemap layout.}
\usage{
treemapify(data, area, fill, group, label, xlim = c(0, 100), ylim = c(0,
  100))

treemapify_fixed(data, area, fill, group, label, xlim = c(0, 100),
  ylim = c(0, 100))
}
\arguments{
\item{data}{A tidy data frame.}

\item{area}{Name of the variable (a column in `data`) to be mapped to the
area of treemap tiles.}

\item{fill}{Name of the variable (a column in `data`) to be mapped to the
fill colour of treemap tiles.}

\item{group}{Optionally, name of the variable (a column in `data`) by which
the tiles will be grouped; that is, in the final treemap layout, these tiles
will be kept together.}

\item{label}{Optionally, name of the variable (a column in `data`) giving
tile labels that will be preserved in the output data frame.}

\item{xlim, ylim}{Optional two-element vectors specifying the x and y limits
of the plot area into which the treemap is to be drawn.}
}
\description{
`treemapify` and `treemapify_fixed` produce a set of raw coordinates used to
draw a treemap from a data frame of observations. To draw a treemap with
'ggplot2', use `geom_treemap` instead.
}
\details{
`treemapify` and `treemapify_fixed` return a data frame of tile coordinates
for the treemap. This is only useful if you wish to draw the treemap without
'ggplot2', or for some edge cases such as treemaps drawn in 'R Shiny' (see
e.g. \url{https://stackoverflow.com/q/45021775}). The easiest way to draw a
treemap with this package is to use the provided 'ggplot2' geoms, such as
`geom_treemap`.

Input data frame must be in tidy format, i.e. each row must represent a
single observation and each column a single variable. You must provide, as
arguments, the names of the variables that will be represented by the area
and fill colour of treemap tiles. Optionally, you can also select a variable
by which to group the tiles within the treemap layout, and a variable that
will be preserved as a label for each tile.

Two algorithms for the tile layout are provided. With the default
'squarified' algorithm (`treemapify`), the priority is ensuring the tiles
have an aesthetically pleasing aspect ratio; that is, they are not too narrow
or too short. In this algorithm, tile placement proceeds from the bottom left
corner, moving alternately rightwards and upwards until all tiles are placed.
See Bruls et al. (1999) for the full algorithm.

With the alternative 'fixed' layout algorithm (`fixed = TRUE`), the plot area
is divided into vertical columns, which are filled from left to right with an
equal number of tiles beginning at the bottom of each column. Unlike the
default 'squarified' algorithm, with the 'fixed' algorithm the relative
positions of the tiles are fixed by their order in the input data frame. This
can result in aesthetically unpleasing tiles, but it allows side-by-side
comparisons or animations to be created.
}
\examples{

treemapify(G20, area = "gdp_mil_usd", fill = "hdi", group = "region",
           label = "country")


treemapify_fixed(G20, area = "gdp_mil_usd", fill = "hdi", group = "region",
           label = "country")

}
\references{
Bruls, M., Huizing, K., & van Wijk, J. (1999). Squarified Treemaps (pp.
33-42).Proceedings of the Joint Eurographics and IEEE TCVG Symposium on
Visualization. \url{http://www.win.tue.nl/~vanwijk/stm.pdf}
}
\seealso{
geom_treemap
}
