\name{tmLocate}
\alias{tmLocate}
\title{Returns info about clicked rectangle}
\usage{
  tmLocate(npcClick, tmSave)
}
\arguments{
  \item{npcClick}{mouse click in npc coordinates, which can
  be generated by \code{\link{tmClick}}}

  \item{tmSave}{treemap information: value returned by
  \code{\link{tmPlot}}}
}
\description{
  This function returns information about the object on
  which user has clicked.
}
\examples{
data(sbsData)
\dontrun{
tmSave <- tmPlot(sbsData,
				 index="section",
				 vSize="employees09+value added09+turnover09+salaries09",
				 vColor="employees08+value added08+turnover08+salaries08",
				 sortID="-size")
	# capture mouseclick
	npcClick <- tmClick()

	# locate clicked object
	print(tmLocate(npcClick, tmSave))
}
}

