% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server-methods.R
\name{searchTxnyms}
\alias{searchTxnyms}
\title{Get node labels based on online taxonomic database}
\usage{
searchTxnyms(tree, cache = FALSE, parent = NULL, clean = TRUE, infer = TRUE)
}
\arguments{
\item{tree}{TreeMan object}

\item{cache}{T/F, create a local cache of downloaded names?}

\item{parent}{specify parent of all names to prevent false names}

\item{clean}{T/F, ensure returned names contain no special characters?}

\item{infer}{T/F, infer taxonyms for unfound nodes?}
}
\description{
Return names of each node in tree based on searching tip labels
 through Global Names Resolver \url{http://resolver.globalnames.org/} in NCBI.
}
\details{
For each node, all the descendants are searched, the taxonomic lineages returned and
then searched to find the lowest shared name.
All the tip labels are searched against a specified taxonomic database through the GNR and NCBI.
(So far only tested with NCBI database.)
Use the infer argument to ensure a taxonym is returned for all nodes. If infer is true,
all nodes without an identifed taxonym adopt the taxonym of their parent.
Will raise a warning if connection fails and will return NULL.
}
\examples{
tree <- randTree(8)
new_tids <- c("Gallus_gallus", "Aileuropoda_melanoleucha", "Ailurus_fulgens",
"Rattus_rattus", "Mus_musculus", "Gorilla_gorilla", "Pan_trogoldytes", "Homo_sapiens")
tree <- setNdsID(tree, tree['tips'], new_tids)
nd_labels <- searchTxnyms(tree)
print(nd_labels)
}
\seealso{
\code{\link{taxaResolve}}, \code{\link{setTxnyms}}, \code{\link{getNdsFrmTxnyms}}
}
