% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcFrPrp}
\alias{calcFrPrp}
\title{Calculate evolutionary distinctness}
\usage{
calcFrPrp(tree, tids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{tip IDs}

\item{...}{\code{plyr} arguments}
}
\description{
Returns the evolutationary distinctness of ids using the fair proportion metric.
}
\details{
The fair proportion metric calculates the evolutionary distinctness of tips
in a tree through summing the total amount of branch length each tip represents, where
each branch in the tree is evenly divided between all descendants. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
calcFrPrp(tree, tree['tips'])
}
\references{
Isaac, N.J.B., Turvey, S.T., Collen, B., Waterman, C. and Baillie, J.E.M. (2007). 
 Mammals on the EDGE: conservation priorities based on threat and phylogeny. PLoS ONE, 2, e296.
}
\seealso{
\code{\link{calcPhyDv}}
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}

