% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate.R
\name{tr_bill_rates}
\alias{tr_bill_rates}
\title{Daily treasury bill rates}
\source{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\usage{
tr_bill_rates(date = NULL)
}
\arguments{
\item{date}{(\code{character(1)} | \code{numeric(1)}) date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing the rates or \code{NULL} when no entries were found.
}
\description{
These rates are the daily secondary market quotations on the most recently
auctioned Treasury Bills for each maturity tranche (4-week, 8-week, 13-week,
17-week, 26-week, and 52-week) for which Treasury currently issues new
bills.
}
\details{
Market quotations are obtained at approximately 3:30 PM each business
day by the Federal Reserve Bank of New York. The Bank Discount rate is the
rate at which a bill is quoted in the secondary market and is based on the
par value, amount of the discount and a 360-day year. The Coupon Equivalent,
also called the Bond Equivalent, or the Investment Yield, is the bill's
yield based on the purchase price, discount, and a 365- or 366-day year. The
Coupon Equivalent can be used to compare the yield on a discount bill to the
yield on a nominal coupon security that pays semiannual interest with the
same maturity date.
}
\examples{
\donttest{
# get data for a single month
tr_bill_rates("202201")
# or for the entire year
tr_bill_rates(2022)
}
}
\seealso{
Other interest rate: 
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_real_yield_curve}()},
\code{\link{tr_yield_curve}()}
}
\concept{interest rate}
