% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveoutletstostrm.R
\name{taudem_moveoutletstostream}
\alias{taudem_moveoutletstostream}
\title{Move Outlets To Streams}
\usage{
taudem_moveoutletstostream(
  input_d8flowdir_grid,
  input_stream_raster_grid,
  output_moved_outlets_file = NULL,
  om_layer_name = NULL,
  max_dist = NULL,
  outlet_file,
  outlet_layer_name = NULL,
  outlet_layer_number = NULL,
  n_processes = getOption("traudem.n_processes", 1),
  quiet = getOption("traudem.quiet", FALSE)
)
}
\arguments{
\item{input_d8flowdir_grid}{File name for D8 flow direction grid (input).}

\item{input_stream_raster_grid}{File name for stream raster grid (input).}

\item{output_moved_outlets_file}{Output OGR file where outlets have been moved.}

\item{om_layer_name}{layer name in movedoutletsfile (optional).}

\item{max_dist}{maximum number of grid cells to traverse in moving outlet points (optional).}

\item{outlet_file}{input outlets file (OGR readable dataset).}

\item{outlet_layer_name}{OGR layer name if outlets are not the first layer in \code{outlet_file} (optional).
Layer name and layer number should not both be specified.}

\item{outlet_layer_number}{OGR layer number if outlets are not the first layer in \code{outlet_file} (optional).
Layer name and layer number should not both be specified.}

\item{n_processes}{Number of processes for \code{mpiexec}. If \code{NULL} TauDEM is called without mpiexec.}

\item{quiet}{If \code{FALSE} output from TauDEM CLI is suppressed.}
}
\value{
Path to output file (invisibly).
}
\description{
Move Outlets To Streams
}
\details{
See \url{https://hydrology.usu.edu/taudem/taudem5/help53/MoveOutletsToStreams.html}
}
