% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-strings.R
\name{str_to}
\alias{str_to}
\alias{str_to.default}
\alias{str_trim}
\title{Character String Utilities}
\usage{
str_to(x, ...)

\method{str_to}{default}(x, quote_values = FALSE, last_sep = ", or ", ...)

str_trim(x = character(), width = 80L)
}
\arguments{
\item{x}{Any \R object for \code{\link[=str_to]{str_to()}}. A character vector for \code{\link[=str_trim]{str_trim()}}.}

\item{...}{Further arguments passed to, or from other methods.}

\item{quote_values}{A non-\link[base:NA]{NA} logical value. Should elements of
\code{x} be quoted?}

\item{last_sep}{A non-empty and non-\link[base:NA]{NA} character string
separating the last element from the penultimate one.}

\item{width}{A non-\link[base:NA]{NA} integer value. The target width for
individual elements of \code{x}. It takes 3 more characters into account
for the \code{...} suffix.}
}
\value{
\code{\link[=str_to]{str_to()}} returns a character string.

\code{\link[=str_trim]{str_trim()}} returns a character vector having the same length as \code{x}.
}
\description{
\code{\link[=str_to]{str_to()}} converts an \R object to a character string. It is a slightly
more flexible alternative to \code{\link[base:toString]{base::toString()}}.

\code{\link[=str_trim]{str_trim()}} wraps \code{\link[base:strtrim]{base::strtrim()}} and further adds a \code{...} suffix to
each trimmed element.
}
\details{
\code{\link[=str_to]{str_to()}} concatenates all elements with \code{", "}, except for the last
one. See argument \code{last_sep}.
}
\seealso{
Other utility functions: 
\code{\link{format_vector}()},
\code{\link{stops}()},
\code{\link{vapply_1l}()}
}
\concept{utility functions}
\keyword{internal}
