% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssEndIf.R
\name{xpssEndIf}
\alias{xpssEndIf}
\title{Ends a DO IF - END IF subset}
\usage{
xpssEndIf(x)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}
}
\value{
Output is the original dataset.
}
\description{
R implementation of the SPSS \code{END IF} argument.
}
\details{
\code{xpssEndIf} determines the end of the analysis based on logical conditions via \code{\link{xpssDoIf}}.  \code{xpssEndIf} merge the excluded data with the actual dataset, after \code{xpssDoIf} subsetted the data. All changes which were made until \code{xpssEndIf} will be taken over, the excluded data will remain untouched!\cr \cr

\strong{NOTE:} For temporary case selection, specify \code{xpssTemporary} before \code{xpssDoIf}.
}
\examples{
data(fromXPSS)

temp <- xpssDoIf(x=fromXPSS, cond = "V3 == 1")

temp <- xpssRecode(x=temp,variables="V5",rec="lo:78 = 1; else = 2")

temp <- xpssEndIf(x=temp)
}
\author{
Andreas Wygrabek
}

