% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeMissings.R
\name{computeNmiss}
\alias{computeNmiss}
\title{Displays the amount of missing values in variables.}
\usage{
computeNmiss(x, variables = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the names of the variables.}
}
\value{
atomic numeric with the length of the data. Returns the amount of
system- or user-defined missing values of the variables.
}
\description{
R implementation of the SPSS \code{Nmiss} function
}
\details{
Performs a missing value operation. \code{computeNmiss} displays the amount of system- and user-defined missing values of the variables. \cr User-defined and system-defind missings values get handled as one type of missing value.
}
\examples{
data(fromXPSS)

xpssCompute(x=fromXPSS, variables=c("V6","V7_2"), fun="computeNmiss")
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{computeMiss}} , \code{\link{computeNvalid}} , \code{\link{computeSysmis}} ,\code{\link{computeValue}}
}
\keyword{internal}

