% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoxicon_scores.R
\name{emoxicon_scores}
\alias{emoxicon_scores}
\title{Emoxicon Scores}
\usage{
emoxicon_scores(text, lexicon, exclude)
}
\arguments{
\item{text}{Matrix or data frame.
A data frame containing texts to be scored (one text per row)}

\item{lexicon}{The lexicon used to score the words. The default is the \code{\link{emotions}} dataset,
a modification of the lexicon developed by Araque, Gatti, Staiano, and Guerini (2018).
To use the raw lexicon from Araque et. al (2018) containing the original probability weights, use the \code{\link{weights}} dataset.
If another custom lexicon is used, the first column of the lexicon should contain the terms
and the subsequent columns contain the scoring categories.}

\item{exclude}{A vector listing terms that should be excluded from the lexicon.
Words specified in \code{exclude} will not
influence document scoring. Users should consider excluding 'red herring' words
that are more closely related to the topics of the documents,
rather than the documents' emotional content.
For example, the words "clinton" and "trump" are present in the lexicon and are both associated with the emotion 'AMUSED'.
Excluding these words when analyzing political opinions may produce more accurate results.}
}
\description{
A bag-of-words approach for computing emotions in text data using
the lexicon compiled by Araque, Gatti, Staiano, and Guerini (2018).
}
\examples{

# Obtain "emotions" data
data("emotions")

# Obtain "tinytrolls" data
data("tinytrolls")

\dontrun{
# Obtain emoxicon scores for first 10 tweets
emotions_tinytrolls <- emoxicon_scores(text = tinytrolls$content, lexicon = emotions)
}

}
\references{
Araque, O., Gatti, L., Staiano, J., and Guerini, M. (2018).
DepecheMood++: A bilingual emotion lexicon built through simple yet powerful techniques.
\emph{ArXiv}
}
\seealso{
\code{\link{emotions}}, where we describe how we modified the original DepecheMood++ lexicon.
}
\author{
Tara Valladares <tls8vx at virginia.edu> and Hudson F. Golino <hfg9s at virginia.edu>
}
