% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{variable.names.tramME}
\alias{variable.names.tramME}
\title{Return variable names.}
\usage{
\method{variable.names}{tramME}(object, which = c("all", "response",
  "grouping", "shifting", "interacting"), ...)
}
\arguments{
\item{object}{a tramME object (fitted or unfitted)}

\item{which}{all: all non-eliminated variable names,
response: response variable,
grouping: grouping factors for random effects,
shifting: shifting variables,
interacting: interacting variables.}

\item{...}{optional parameters}
}
\value{
A vector of variable names.
}
\description{
Returns the variable names corresponding the selected group.
The returned names are derived names as tramME uses them. For example, when the
response is a Surv object, \code{variable.names} returns the name of that object, and
the names of the variables used to create it.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
variable.names(mod)
variable.names(mod, "response")
}
