% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/straightness.R
\name{TrajSinuosity}
\alias{TrajSinuosity}
\title{Sinuosity of a trajectory}
\usage{
TrajSinuosity(trj, compass.direction = NULL)
}
\arguments{
\item{trj}{Trajectory to calculate sinuosity of.}

\item{compass.direction}{if not \code{NULL}, turning angles are calculated
for a directed walk, assuming the specified compass direction (in radians).
Otherwise, a random walk is assumed.}
}
\value{
The sinuosity of \code{trj}.
}
\description{
Calculates the sinuosity of a trajectory as defined by Bovet & Benhamou
(1988), which is: \eqn{S = 1.18\sigma / \sqrt q} where \eqn{\sigma} is the
standard deviation of the step turning angles and \eqn{q} is the mean step
length. A corrected sinuosity index is available as the function
\code{\link{TrajSinuosity2}} which handles a wider range of variations in
step angles.
}
\references{
Bovet, P., & Benhamou, S. (1988). Spatial analysis of animals' movements
using a correlated random walk model. Journal of Theoretical Biology, 131(4),
419-433. doi:10.1016/S0022-5193(88)80038-9
}
\seealso{
\code{\link{TrajAngles}} for the turning angles in a trajectory,
  \code{\link{TrajStepLengths}} for the step lengths,
  \code{\link{TrajSinuosity2}} for a corrected version of sinuosity.
}
