% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InternalTrajeR.R
\name{trajeR.BETA}
\alias{trajeR.BETA}
\title{Internal function to fit Beta regression}
\usage{
trajeR.BETA(
  Y,
  A,
  X,
  TCOV,
  ng,
  nx,
  n,
  nbeta,
  nphi,
  nw,
  ntheta,
  period,
  degre,
  theta,
  beta,
  phi,
  delta,
  pi,
  Method,
  hessian,
  itermax,
  paraminit,
  EMIRLS,
  refgr
)
}
\arguments{
\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{X}{Matrix. An optional matrix that modify the probability of belong to group. By default its value is a matrix
with one column  with value 1.}

\item{TCOV}{Matrix. An optional matrix containing the time covariate that influence the trajectory themselves.
By default its value is NULL.}

\item{ng}{Integer. The number of groups.}

\item{nx}{Integer. The number of covariates.}

\item{n}{Integer. Number of individuals.}

\item{nbeta}{Vector of integers. Number of beta parameters for each group.}

\item{nphi}{Vector of integers. Number of phi parameters for each group.}

\item{nw}{Integer. Number of time dependent covariate.}

\item{ntheta}{Vector of integers. Number of theta parameters for each group.}

\item{period}{Integer.}

\item{degre}{Vector of integer. The degree of every polynomial function.}

\item{theta}{Vector of real. The parameter for calculated the group membership probability.}

\item{beta}{Vector of real. The beta parameter.}

\item{phi}{Vector of real. The phi parameter.}

\item{delta}{Vector of real. The delta parameter.}

\item{pi}{Vector of real. The group membership probability.}

\item{Method}{String. Determine the method used for find the parameters of the model.
The value are L for the Maximum Likelihood Estimation, EM for Expectation Maximization method
with quasi newton method inside, EMIWRLS for Expectation Maximization method with Iterative
Weighted Least Square.}

\item{hessian}{Logical. Indicate if we want calculate the hessian matrix. Default is FALSE.
If the method use is Likelihood, the hessian is calculated by inverting the Information's Fisher Matrix.
To avoid numerically singular matrix we find the pseudo inverse matrix by using the \code{ginv} function int he package MASS.
If the method is EM or EMIWRLS, the hessian is calculated by using Louis method.}

\item{itermax}{Integer. Indicate the maximal number of iteration for \code{optim} function or for the EM algorithm.}

\item{paraminit}{Vector. The vector of initial parameters. By default \code{trajeR} calculate the initial value
based of the range or the standard deviation.}

\item{EMIRLS}{Boolean. True if we use EMIRLS method.}

\item{refgr}{Integer. The number of reference group. By default is 1.}
}
\value{
return a object of class Trajectory.NL
\itemize{
  \item beta -  vector of the parameter beta.
  \item sigma - vector of the parameters sigma.
  \item delta - vector of the parameter delta. Only if we use time covariate.
  \item theta - vector with the parameter theta if there exist a coavriate X that modify
  the probability or the probability of group membership.
  \item sd - vector of the standard deviation of the parameters.
  \item tab - a matrix with all the parameters and standard deviation.
  \item Model - a string with the model used.
  \item groups -  a integer with the number of group.
  \item Names - strings with the name of the parameters.
  \item Method  -  a string with the method used.
  \item Size - a integer with the number of individuals.
  \item Likelihood -  a real with the Likelihood obtained by the parameters.
  \item Time - a vector with the first row of time values.
  \item degre - a vector with the degree of the polynomial shape.
}
}
\description{
Internal function to fit Beta regression
}
