% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icar.R
\name{sample_icar}
\alias{sample_icar}
\title{Sample ICAR random effects with component-wise sum-to-zero constraints}
\usage{
sample_icar(
  A,
  tau = 1,
  kappa = 1e+06,
  isolate = c("independent", "drop"),
  isolate_prec = NULL
)
}
\arguments{
\item{A}{Sparse adjacency matrix (dgCMatrix preferred).}

\item{tau}{Positive precision multiplier.}

\item{kappa}{Large penalty enforcing sum-to-zero (default 1e6).}

\item{isolate}{How to handle isolated nodes: "independent" or "drop".}

\item{isolate_prec}{Precision for isolated nodes if kept independent.}
}
\value{
Numeric vector of length nrow(A).
}
\description{
Sample ICAR random effects with component-wise sum-to-zero constraints
}
\keyword{internal}
